% Dynamic OCT methods for Fig. 2 and Vis. 1
%
% Biomedical Optics Express paper titled:
% Review of dynamic optical coherence tomography for intracellular motility: 
%    Signals, metrics, and their applications 
%
% Amy Josefsberg, June, 2025

function [outImg] = func_motil(imgStack)
% Eq. (9) and (S62)
    n = size(imgStack,3); 
    meanS = mean(imgStack,3); 
    meanS1 = mean(imgStack(:,:,1:end-1),3); 
    meanS2 = mean(imgStack(:,:,2:end),3); 
    outImg = sqrt(max ( sum( imgStack(:,:,1:end-1).*imgStack(:,:,2:end) ,3 )/(n-1) - meanS1.*meanS2,0) )./meanS;

end